
#
# Regular expressions that will match the output of "uname -s"
# to match the target operating system.
#
WINNAME = "CYGWIN.*"
LINNAME = "Linux.*"
UNKNAME = "UNKNOWN"

WINOBJDIR = Windows-objs
LINOBJDIR = Linux-objs
UNKOBJDIR = UNKNOWN

UNAME = $(shell uname -s)
WINMATCH = $(shell expr $(UNAME) : "\($(WINNAME)\)")
LINMATCH = $(shell expr $(UNAME) : "\($(LINNAME)\)")

OBJ = $(if $(WINMATCH),$(WINOBJDIR),$(if $(LINMATCH),$(LINOBJDIR),$(UNKOBJDIR)))

$(OBJ)/%.o : %.c
	$(CC) -c $(CFLAGS) $(CPPFLAGS) -o $@ $<

#
# for later
# depends:
#	@gcc -M -MG *.c                   | \
#	    sed -e "s+/usr/include.* ++"   \
#	        -e "s+/usr/lib.* ++"       \
#		-e "s+\\\\++"              \
#		-e "/^ *$$/d"		 | \
#	    sed -n '/:/{;x;s/\n/ /gp;};/:/!H;$${;x;s/\n/ /gp;}' | \
#	    sed  -e "s/  */ /g"
